Texture2D<float4>	tex0	: register(t0);
SamplerState		samp0	: register(s0);

struct PSInput{
	float4	position	: SV_POSITION;
	float4	uv			: TEXCOORD;
};

PSInput VSMain(float4 position : POSITION, float4 uv : TEXCOORD)
{
	PSInput	result;

	result.position = position;
	result.uv = uv;

	return result;
}

float4 PSMain(PSInput input) : SV_TARGET
{
	return tex0.Sample(samp0, input.uv);
}
